"use client";

import { Button } from "@heroui/react";
import { ArrowUpRight } from "lucide-react";

export const PrimaryButton = ({ text }: { text: string }) => {
  return (
    <Button
      endContent={
        <div className="size-6 rounded-full bg-white flex justify-center items-center">
          <ArrowUpRight className="text-primary size-5" />
        </div>
      }
      variant="bordered"
      className="text-white border-white hover:bg-[#84CEEE33] hover:border-secondary primary-transition"
      radius="full"
    >
      {text}
    </Button>
  );
};
