"use client";

import { Divider } from "@heroui/react";
import { useLocale } from "next-intl";
import Image from "next/image";
import Link from "next/link";

export type Service = {
  title: string;
  description: string;
  image: string;
  slug: string;
};

export const ServiceCard = ({ service }: { service: Service }) => {
  return (
    <Link href={`/services/${service?.slug}`}>
      <article className="flex flex-col h-full justify-between gap-4 md:gap-7 rounded-3xl bg-mainBg border border-[#DFDFDF] p-4.5 shadow-sm group overflow-hidden">
        <div className="flex flex-col gap-3">
          <h3 className="h5Text text-secondary line-clamp-2">
            {service?.title}
          </h3>
          <Divider className="text-secondary" />
          <p className="captionText text-thirdText leading-relaxed line-clamp-3">
            {service?.description}
          </p>
        </div>

        <div className="relative mt-2 rounded-2xl overflow-hidden h-[140px]">
          <Image
            src={service?.image}
            alt={service?.title}
            width={280}
            height={180}
            className="object-cover w-full h-full mix-blend-luminosity group-hover:mix-blend-normal group-hover:scale-110 transition-all duration-500 ease-out"
          />
        </div>
      </article>
    </Link>
  );
};
