import Image from "next/image";
import Link from "next/link";
import { navLinks, socialLinks } from "./Navbar";

export const Footer = () => {
  const year = new Date().getFullYear();

  return (
    <footer className="bg-[#F9F9FB] py-10 md:py-16 rounded-4xl">
      <div className="custom-container">
        <div className="rounded-3xl bg-[#F9F9FB] px-6 py-8 md:px-10 md:py-10 flex flex-col gap-8">
          {/* Top content */}
          <div className="flex flex-col lg:flex-row gap-8 lg:gap-16 items-start justify-between">
            {/* Logo & company info */}
            <div className="flex flex-col gap-3 max-w-sm">
              <div className="flex items-center gap-4">
                <Image
                  src="/images/logo.png"
                  alt="Hellenic Glamor Logo"
                  width={75}
                  height={75}
                />
              </div>

              <p className="h6Text text-primaryText">
                Hellenic Glamor Ship Management L.L.C
              </p>
            </div>

            {/* Quick links & socials */}
            <div className="flex flex-col gap-6 md:gap-8">
              {/* Quick Links */}
              <div className="flex flex-col sm:flex-row sm:items-center gap-3 sm:gap-5 md:gap-10">
                <p className="h6Text text-primaryText whitespace-nowrap xl:w-[17%]">
                  Quick Links
                </p>
                <ul className="flex flex-wrap gap-x-4 gap-y-2 sm:gap-5">
                  {navLinks?.map((item) => (
                    <li key={item.link}>
                      <Link
                        href={item.link}
                        className="bodyText text-thirdText hover:text-primary transition-colors duration-300"
                      >
                        {item.title}
                      </Link>
                    </li>
                  ))}
                </ul>
              </div>

              {/* Social Links */}
              <div className="flex flex-col sm:flex-row sm:items-center gap-3 sm:gap-5 md:gap-10">
                <p className="h6Text text-primaryText whitespace-nowrap xl:w-[17%]">
                  Follow us
                </p>
                <div className="flex items-center gap-3">
                  {socialLinks?.map((item, index) => (
                    <a
                      key={index}
                      href={item?.href}
                      target="_blank"
                      rel="noopener noreferrer"
                      aria-label={item?.ariaLabel}
                      className="size-8 rounded-full bg-primary flex items-center justify-center hover:bg-primary/85 transition-all duration-300"
                    >
                      <Image
                        src={item?.icon}
                        alt={item?.ariaLabel}
                        width={16}
                        height={16}
                      />
                    </a>
                  ))}
                </div>
              </div>
            </div>
          </div>

          {/* Bottom bar */}
          <div className="h-px w-full bg-secondary/20" />

          <div className="flex flex-col md:flex-row items-start md:items-center justify-center gap-4">
            {/* Copyright & Powered by */}
            <div className="flex flex-col sm:flex-row flex-wrap sm:items-center gap-2 sm:gap-4 text-thirdText">
              <p className="smallText">
                © {year} Hellenic Glamor. All rights reserved.
              </p>
              <p className="flex items-center gap-1.5 smallText">
                Powered By{" "}
                <a
                  href="https://www.unocodetech.com/en"
                  target="_blank"
                  rel="noopener noreferrer"
                  className="text-primary hover:opacity-80 transition-opacity duration-300 font-medium"
                >
                  UnoCode
                </a>
              </p>
            </div>

            {/* Legal Links */}
            {/* <div className="flex items-center gap-4 flex-wrap">
              <Link
                href="/terms"
                className="smallText text-thirdText hover:text-primary transition-colors duration-300"
              >
                Terms &amp; Conditions
              </Link>
              <Link
                href="/privacy"
                className="smallText text-thirdText hover:text-primary transition-colors duration-300"
              >
                Privacy Policy
              </Link>
            </div> */}
          </div>
        </div>
      </div>
    </footer>
  );
};
