"use client";

import { cn } from "@/utils";
import { ChevronDown, Globe } from "lucide-react";
import { Locale, useLocale } from "next-intl";
import { useState, useTransition } from "react";
import { Dropdown } from "../dropdown";
import Image from "next/image";
import { useParams } from "next/navigation";
import { usePathname, useRouter } from "@/i18n/navigation";

export const LanguageDropDown = ({
  variant = "navbar",
}: {
  variant?: "navbar" | "sidebar";
}) => {
  const [isOpen, setIsOpen] = useState<boolean>(false);
  const router = useRouter();
  const [isPending, startTransition] = useTransition();
  const pathname = usePathname();
  const params = useParams();
  const locale = useLocale();

  function onSelectChange(lang: Locale) {
    startTransition(() => {
      router.replace(
        // @ts-expect-error -- TypeScript will validate that only known `params`
        // are used in combination with a given `pathname`. Since the two will
        // always match for the current route, we can skip runtime checks.
        { pathname, params },
        { locale: lang }
      );
    });
  }

  const buttonStyles =
    variant === "sidebar"
      ? "flex items-center gap-2 w-full px-3 py-2 cursor-pointer bg-bodyBg/70 hover:bg-secondaryText hover:dark:bg-bodyBg rounded-lg primary-transition"
      : "flex items-center gap-1.5 w-full px-4 py-2 cursor-pointer bg-bodyBg/70 hover:bg-secondaryText hover:dark:bg-bodyBg border border-border-1 rounded-[50px] primary-transition hover:opacity-90";

  return (
    <Dropdown
      title={
        <div className={buttonStyles}>
          {/* <img
            src={locale === "ar" ? "/sa-flag.svg" : "/uk-flag.svg"}
            alt={locale === "ar" ? "arabic" : "english"}
            className="size-4"
          /> */}
          <Globe className="size-4" />
          <span className="text-sm text-primaryText">
            {locale === "ar" ? "العربية" : "English"}
          </span>
          <ChevronDown
            size={16}
            className={variant === "sidebar" ? "ms-auto" : ""}
          />
        </div>
      }
      isOpen={isOpen}
      setIsOpen={setIsOpen}
    >
      <ul className="flex flex-col gap-1" role="menu">
        <li
          className="flex items-center gap-2 cursor-pointer"
          onClick={() => onSelectChange("ar")}
        >
          <Image
            src="/sa-flag.svg"
            alt="Saudi Flag"
            width={20}
            height={20}
            className="size-5"
          />
          <span
            className={cn(
              "bodyText",
              locale === "ar" ? "text-primary" : "text-primaryText"
            )}
          >
            العربية
          </span>
        </li>
        <li
          className="flex items-center gap-2 cursor-pointer"
          onClick={() => onSelectChange("en")}
        >
          <Image
            src="/uk-flag.svg"
            alt="UK Flag"
            width={20}
            height={20}
            className="size-5"
          />
          <span
            className={cn(
              "bodyText",
              locale === "ar" ? "text-primary" : "text-primaryText"
            )}
          >
            English
          </span>
        </li>
      </ul>
    </Dropdown>
  );
};
