export const SetSrc = (url: string = "", type: "Full" | "Media" = "Media") => {
  if (!url) return "";
  if (url.startsWith("/") || url.startsWith("http")) {
    return url;
  }

  let api = "";
  switch (type) {
    case "Full":
      api = process.env.NEXT_PUBLIC_API_URL ?? "";
      break;
    case "Media":
      api = process.env.NEXT_PUBLIC_MEDIA_URL ?? "";
      break;
    default:
      break;
  }

  const sanitizedUrl = url.replace(/^\/+/, "");

  return api ? `${api}/storage/${sanitizedUrl}` : `/${sanitizedUrl}`;
};
