"use client";

import { useRef } from "react";
import { motion, useInView } from "framer-motion";
import Image from "next/image";

const EASE_OUT_EXPO = [0.16, 1, 0.3, 1] as const;

const containerVariants = {
  hidden: {},
  visible: {
    transition: {
      staggerChildren: 0.15,
      delayChildren: 0.1,
    },
  },
};

const titleVariants = {
  hidden: { opacity: 0, y: 20, filter: "blur(8px)" },
  visible: {
    opacity: 1,
    y: 0,
    filter: "blur(0px)",
    transition: { duration: 0.6, ease: EASE_OUT_EXPO },
  },
};

const dividerVariants = {
  hidden: { scaleX: 0, opacity: 0 },
  visible: {
    scaleX: 1,
    opacity: 1,
    transition: { duration: 0.8, ease: EASE_OUT_EXPO },
  },
};

const textVariants = {
  hidden: { opacity: 0, y: 15 },
  visible: {
    opacity: 1,
    y: 0,
    transition: { duration: 0.6, ease: EASE_OUT_EXPO },
  },
};

const imageVariants = {
  hidden: { opacity: 0, scale: 0.92, x: 30 },
  visible: {
    opacity: 1,
    scale: 1,
    x: 0,
    transition: { duration: 0.8, ease: EASE_OUT_EXPO },
  },
};

export const FleetManagementApproach = () => {
  const sectionRef = useRef<HTMLElement | null>(null);
  const isInView = useInView(sectionRef, { once: true, margin: "-100px" });

  return (
    <motion.section
      ref={sectionRef}
      initial="hidden"
      animate={isInView ? "visible" : "hidden"}
      variants={containerVariants}
      className="rounded-3xl bg-primary text-secondaryText px-6 py-10 md:px-10 md:py-12 flex flex-col lg:flex-row gap-8 items-center"
    >
      <div className="flex-1 space-y-4">
        <motion.h3 variants={titleVariants} className="h3Text">
          Management Approach
        </motion.h3>

        <motion.div
          variants={dividerVariants}
          className="h-px w-full bg-secondary origin-left"
        />

        <motion.p
          variants={textVariants}
          className="bodyText text-secondaryText/90 leading-relaxed"
        >
          Our fleet is managed through a structured framework covering ship
          management, crewing, supplies, maintenance, scheduling, and dry-dock
          coordination. Every vessel is monitored for operational readiness,
          compliance, safety, and performance, ensuring owners receive
          consistent updates and reliable, transparent oversight.
        </motion.p>
      </div>

      <motion.div variants={imageVariants} className="flex-1 w-full max-w-sm">
        <div className="relative rounded-3xl overflow-hidden min-h-[220px] md:min-h-[260px]">
          <Image
            src="/images/home/slide-2.jpg"
            alt="Fleet management team"
            fill
            className="object-cover"
          />
        </div>
      </motion.div>
    </motion.section>
  );
};
