"use client";

import { useLocale } from "next-intl";
import data from "@/data/home.json";
import { CTASection } from "../shared";

export const HomeContactSection = () => {
  const locale = useLocale();
  const cta = data?.consultationCta;
  const buttonConfig = cta?.buttons?.[0];
  const title = locale === "ar" ? cta?.title_ar ?? "" : cta?.title_en ?? "";
  const description = locale === "ar" ? cta?.text_ar ?? "" : cta?.text_en ?? "";
  const buttonLabel =
    locale === "ar"
      ? buttonConfig?.label_ar ?? buttonConfig?.label_en ?? ""
      : buttonConfig?.label_en ?? "";

  return (
    <CTASection
      title={title}
      description={description}
      backgroundImage={cta?.image}
      buttonLabel={buttonLabel}
      buttonHref={"/contact"}
      imageAlt={title}
    />
  );
};
