"use client";

import { motion } from "framer-motion";
import Image from "next/image";
import { Breadcrumbs, BreadcrumbItem } from "@heroui/react";

export type BreadcrumbType = {
  label: string;
  href?: string;
  isCurrent?: boolean;
};

export type PageHeroProps = {
  title: string;
  backgroundImage: string;
  breadcrumbs: BreadcrumbType[];
};

export const PageHero = ({
  title,
  backgroundImage,
  breadcrumbs,
}: PageHeroProps) => {
  return (
    <motion.section
      className="p-4 md:p-6"
      initial={{ opacity: 0 }}
      animate={{ opacity: 1 }}
      transition={{ duration: 0.6 }}
    >
      <div className="relative w-full max-w-full h-[30vh] md:h-[55vh] rounded-2xl overflow-hidden">
        {/* Background Image */}
        <Image
          src={backgroundImage}
          alt={`${title} hero`}
          fill
          className="object-cover"
          priority
        />

        {/* Gradient Overlay */}
        <div
          className="absolute inset-0 z-10"
          style={{
            background:
              "linear-gradient(360deg, rgba(6, 51, 86, 0.7) 100%, rgba(6, 51, 86, 0.8) 100%)",
          }}
        />

        {/* Content */}
        <div className="relative h-full z-20 flex flex-col items-center justify-end gap-5 pb-4 md:pb-12 text-center px-4">
          <motion.h1
            className="h2Text tracking-widest text-white"
            initial={{ opacity: 0, y: 20 }}
            animate={{ opacity: 1, y: 0 }}
            transition={{ duration: 0.6, delay: 0.2 }}
          >
            {title}
          </motion.h1>

          <motion.div
            initial={{ opacity: 0, y: 20 }}
            animate={{ opacity: 1, y: 0 }}
            transition={{ duration: 0.6, delay: 0.4 }}
          >
            <Breadcrumbs
              separator="."
              classNames={{
                list: "gap-2",
              }}
              itemClasses={{
                item: "bodyText text-white data-[current=true]:text-white",
                separator: "text-white",
              }}
            >
              {breadcrumbs?.map((crumb, index) => (
                <BreadcrumbItem
                  key={index}
                  href={crumb.href}
                  isCurrent={crumb.isCurrent}
                >
                  {crumb.label}
                </BreadcrumbItem>
              ))}
            </Breadcrumbs>
          </motion.div>
        </div>
      </div>
    </motion.section>
  );
};
