// src/components/JsonLd.tsx
"use client";

import Script from "next/script";

export const OrganizationJsonLd = () => {
  const jsonLd = {
    "@context": "https://schema.org",
    "@type": "Organization",
    name: "website",
    alternateName: [],
    url: "https://website.com",
    logo: "https://website.com/logo.png",
  };

  return (
    <Script
      id="ld-json-script"
      type="application/ld+json"
      dangerouslySetInnerHTML={{
        __html: JSON.stringify(jsonLd),
      }}
    />
  );
};
