"use client";

import Link from "next/link";
import { useLocale } from "next-intl";
import { usePathname } from "next/navigation";
import { Home } from "lucide-react";
import { cn } from "@/utils";

export const MobileBottomBar = () => {
  const locale = useLocale();
  const pathname = usePathname();

  const isActive = (href: string) => pathname?.startsWith(href);

  const items = [
    {
      key: "home",
      href: `/${locale}`,
      label: locale === "ar" ? "الرئيسية" : "Home",
      icon: Home,
      active:
        isActive(`/${locale}`) &&
        (pathname === `/${locale}` || pathname === `/${locale}/`),
    },
  ];

  return (
    <nav
      className={
        "md:hidden fixed inset-x-0 bottom-0 z-50 pb-[env(safe-area-inset-bottom)]"
      }
    >
      <div className="mx-auto max-w-6xl px-4">
        <div className="rounded-2xl border border-border-2 bg-mainBg/90 backdrop-blur supports-backdrop-filter:bg-mainBg/70 shadow-lg">
          <ul className="grid grid-cols-1">
            {items?.map(({ key, href, label, icon: Icon, active }) => (
              <li key={key}>
                <Link
                  href={href}
                  className={cn(
                    "flex flex-col items-center justify-center gap-1 py-3",
                    "transition-colors",
                    active ? "text-secondary" : "text-primary"
                  )}
                >
                  <span
                    className={cn(
                      "inline-flex items-center justify-center rounded-full",
                      active ? "bg-secondary/15" : "bg-foreground/5",
                      "p-2"
                    )}
                  >
                    <Icon
                      className={cn("h-5 w-5", active && "text-secondary")}
                    />
                  </span>
                  <span
                    className={cn(
                      "text-xs font-medium",
                      active && "text-secondary"
                    )}
                  >
                    {label}
                  </span>
                </Link>
              </li>
            ))}
          </ul>
        </div>
      </div>
    </nav>
  );
};
