"use client";

import Link from "next/link";
import { ChevronDown } from "lucide-react";
import {
  Dropdown,
  DropdownItem,
  DropdownMenu,
  DropdownTrigger,
} from "@heroui/react";
import { cn } from "@/utils";

interface NavMenuProps {
  data: any[];
  variant?: "desktop" | "mobile";
  locale: string;
}

export const NavMenu = ({
  data,
  variant = "desktop",
  locale,
}: NavMenuProps) => {
  const isMobile = variant === "mobile";
  const containerClasses = isMobile
    ? "flex flex-col gap-4 lg:hidden"
    : "hidden lg:flex items-center gap-5";

  const textColor = isMobile ? "text-white" : "text-white";
  const underlineColor = isMobile ? "before:bg-white" : "before:bg-white";

  return (
    <ul
      className={cn(
        containerClasses,
        "px-8 py-2.5 rounded-4xl bg-white/30 backdrop-blur-lg"
      )}
    >
      {data?.map((item, index) => (
        <li key={index} className="relative overflow-hidden py-2 w-max">
          {item?.children && item?.children.length > 0 ? (
            <Dropdown
              classNames={{
                base: "bg-white/30 backdrop-blur-lg rounded-2xl",
                content:
                  "bg-white/30 backdrop-blur-lg rounded-2xl! p-2 min-w-[240px]",
              }}
            >
              <DropdownTrigger>
                <button
                  className={`h-fit flex items-center gap-1 border-none bg-transparent cursor-pointer ${textColor} hover:opacity-80 transition-opacity`}
                >
                  <span className="h6Text">{item?.title}</span>
                  <ChevronDown className={`size-4 lg:size-5 ${textColor}`} />
                </button>
              </DropdownTrigger>
              <DropdownMenu
                aria-label={`${item?.title} menu`}
                classNames={{
                  list: "gap-1",
                }}
                itemClasses={{
                  base: "rounded-2xl! data-[hover=true]:bg-white/40 data-[hover=true]:text-thirdText transition-all overflow-hidden",
                  title: "bodyText text-thirdText",
                }}
              >
                {item?.children?.map((child: any) => (
                  <DropdownItem
                    key={child?.link}
                    href={`/${locale}${child?.link}`}
                    className="py-2 px-3"
                  >
                    {child?.title}
                  </DropdownItem>
                ))}
              </DropdownMenu>
            </Dropdown>
          ) : (
            <Link
              href={`/${locale}${item?.link}`}
              className={`h6Text relative ${textColor} before:content-[''] before:absolute before:bottom-0 before:left-0 before:h-0.5 before:w-full ${underlineColor} before:translate-x-[-101%] rtl:before:translate-x-[101%] before:transition-transform before:duration-300 hover:before:translate-x-0`}
            >
              {item?.title}
            </Link>
          )}
        </li>
      ))}
    </ul>
  );
};
